IF  ( NOT EXISTS ( SELECT OBJECT_ID FROM SYS.COLUMNS WHERE OBJECT_ID = OBJECT_ID('PDV_VD_TEF') AND NAME LIKE 'TEF_GATEWAY' ) )
BEGIN
    ALTER TABLE DBO.PDV_VD_TEF ADD TEF_GATEWAY VARCHAR(5) NULL;
END;

IF  ( NOT EXISTS ( SELECT OBJECT_ID FROM SYS.COLUMNS WHERE OBJECT_ID = OBJECT_ID('PDV_VD_TEF') AND NAME LIKE 'MODALIDADE' ) )
BEGIN
    ALTER TABLE DBO.PDV_VD_TEF ADD MODALIDADE VARCHAR(7) NULL;
END;

DROP VIEW V_CUPOMFISCAL_CARTAO;
GO

CREATE VIEW V_CUPOMFISCAL_CARTAO
AS
SELECT  VD.CD_EMP,VD.CD_FILIAL,VD.DT_VD,VD.CD_CX,VD.CD_VD,VD.NR_ECF, VD.ST_VD
        ,TEF.CD_ADM_CARTAO AS CD_CONV,ADM.NM_USUAL AS NM_CONV,CASE ADM.TP_ADM WHEN 6 THEN 1 ELSE 0 END AS TP_CARTAO 
        ,TEF.VL_CARTAO AS VLR_CARTAO, TEF.VL_SAQUE_CARTAO  AS VLR_SAQUE,COALESCE(ADM.PARC,1) AS QT_PARC
        ,TEF.COD_REDE,TEF.COD_BANDEIRA,TEF.COD_MODALIDADE
        ,TEF.NSU_SITEF AS NR_TRANSACAO,TEF.NR_AUTORIZACAO,TEF.TEF_GATEWAY, ADM.NM_USUAL AS BANDEIRA
FROM    PDV_VD VD 	
INNER   JOIN PDV_VD_TEF TEF ON VD.CD_EMP = TEF.CD_EMP AND VD.CD_FILIAL = TEF.CD_FILIAL AND VD.CD_VD = TEF.CD_VD
LEFT	JOIN RC_ADM_CARTAO ADM ON TEF.CD_EMP = ADM.CD_EMP AND TEF.CD_ADM_CARTAO = ADM.CD_ADM_CARTAO AND ADM.TP_ADM !=6
WHERE	COALESCE(VD.VLR_CARTAO,0) != 0
GO